using System;
using System.Collections.Generic;

namespace Programme
{
    class Article
    {
        public int weight;
        public int value;

        public Article(int weight, int value)
        {
            this.weight = weight;
            this.value = value;
        }
    }

    class Program
    {
        static void Main()
        {
            string[] first = Console.ReadLine().Split();
            int n = int.Parse(first[0]);
            int W = int.Parse(first[1]);
            float e = float.Parse(first[2]);

            Article[] items = new Article[n];
            for (int i = 0; i < n; i++)
            {
                string[] line = Console.ReadLine().Split();
                items[i] = new Article(int.Parse(line[0]), int.Parse(line[1]));
            }

            int[,] dp = new int[n + 1, W + 1];

            for (int i = 1; i <= n; i++)
            {
                int w = items[i - 1].weight;
                int v = items[i - 1].value;

                for (int cap = 0; cap <= W; cap++)
                {
                    dp[i, cap] = dp[i - 1, cap];

                    if (cap >= w)
                    {
                        int take = dp[i - 1, cap - w] + v;
                        if (take > dp[i, cap])
                            dp[i, cap] = take;
                    }
                }
            }

            int bestValue = dp[n, W];

            List<int> chosen = new List<int>();
            int remW = W;

            for (int i = n; i >= 1; i--)
            {
                if (dp[i, remW] != dp[i - 1, remW])
                {
                    chosen.Add(i);
                    remW -= items[i - 1].weight;
                }
            }

            chosen.Reverse();

            Console.WriteLine(chosen.Count);
            foreach (int idx in chosen) { Console.Write(idx + " "); }
        }
    }
}